﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
*/
#include "gameFunctions/nextDepth.as"
#include "gameFunctions/copyObject.as"
#include "gameFunctions/callUnload.as"
#include "gameFunctions/makeStringObject.as"
	// nestedEval
	// evalPath
	// getImpliedValue
	// resolveContainer
define_swf = function( command_obj )
{
	//trace("define swf command:  name: "+command_obj.data.linkage);
	if(command_obj.data.linkage)
	{// if:  linkage specified
		command_obj.run = function( thisCommand_obj, skipSwfloader )
		{
			// make functions available to inner functions
			command_obj.copyObject = copyObject;
			command_obj.makeStringObject = makeStringObject;
			command_obj.nestedEval = nestedEval;
			command_obj.evalPath = evalPath;
			command_obj.getImpliedValue = getImpliedValue;
			command_obj.resolveContainer = resolveContainer;
			// determine where this clip is being placed  (parse variables if [] are used)
			var target_str = nestedEval( thisCommand_obj.data.target, "RAM", "_this");
			var target = evalPath( target_str, "RAM", "_this");
			
			
			
			// generate instance name if none is supplied		(read variables if [] are used)
			var newName = nestedEval( thisCommand_obj.data.name, "RAM", "_this");
			var nameIndex = 0;
			if(newName==""  ||  newName==undefined)
			{// if:  no instance name is supplied
				do{
					var newName = "swf_"+nameIndex;
					nameIndex++;
				}while(target[newName]);
			}// if:  no instance name is supplied
			
			if(TRACE_SCRIPT)
				trace("Place swf:  "+thisCommand_obj.data.linkage+"   named: "+newName+"   waitForEnd: "+thisCommand_obj.data.waitForEnd);
			
			
			// figure out depth
			var newDepth = (thisCommand_obj.data.depth==-1) ? nextDepth(target) : nestedEval( thisCommand_obj.data.depth, "RAM", "_this");
			
			// store this SWF command for save-game loading
			var storedObj = {};
			copyObject( thisCommand_obj.data, storedObj );
			storedObj.name = newName;
			storedObj.depth = newDepth;
			if(!skipSwfloader)
				ROOT.swfLoader.add( storedObj );		// accesses ROOT.swfLoader  (not to be confused with the movieClipLoader used below)
			
			
			
			// create local loader object
			var swfLoader = new MovieClipLoader();			// This is NOT the same thing as ROOT.swfLoader
			swfLoader.root = ROOT;
			swfLoader.commandData = thisCommand_obj.data.data;
			swfLoader.nextEvent = thisCommand_obj.nextEvent;
			swfLoader.waitForEnd = thisCommand_obj.data.waitForEnd;
			swfLoader.levelId = ROOT.game_mc.uid;
			
			
			
			// remove existing clip with same name
			callUnload( target[newName] );
			target[newName].removeMovieClip();
			// remove existing clip with same depth
			var replaceClip = target.getInstanceAtDepth(newDepth);
			callUnload( replaceClip );
			replaceClip.removeMovieClip();
			
			
			
			// (parse variables if [] are used)
			var linkage = thisCommand_obj.data.linkage;
			linkage = nestedEval( linkage, "RAM", "_this");
			
			
			
			// movieclip linkage
			var externalFile = false;
			target.attachMovie( linkage, newName, newDepth);
			if(	target[newName] == target  ||
					target[newName] == undefined)
			{// if:  no movieClip loaded
				// bitmap linkage
				target.createEmptyMovieClip(newName, newDepth);
				var new_pic = flash.display.BitmapData.loadBitmap( linkage );
				target[newName].attachBitmap(new_pic, 0);
				if(	target[newName]._width == undefined  ||
						target[newName]._width == 0)
				{// if:  no bitmap loaded
					// external file
					var externalFile = true;
				}// if:  no bitmap loaded
				else
				{// if:  internal bitmap loaded
					thisCommand_obj.data.waitForEnd = false;
				}// if:  internal bitmap loaded
			}// if:  no movieClip loaded
			
			
			
			
			
			swfLoader.passData = function( newClip, commandData )
			{
				//#include "gameFunctions/makeStringObject.as"
				// grant access to the sprite whose script is placing the SWF
				newClip.parentSprite = _this;
				// pass the settings to the loaded SWF
				for(var nam in commandData){// for each variable
					var newValue = command_obj.nestedEval( commandData[nam], "RAM", "_this" );
					newValue = command_obj.makeStringObject( newValue, "RAM", "_this" );
					newClip[nam] = newValue;
				}
				
				newClip.onClose = function(){
					//ROOT.swfLoader.remove( thisCommand_obj.data );
					ROOT.swfLoader.remove( storedObj );
				}// onClose()
				
				// announce that the parameters are available
				// ... after waiting a moment
				setTimeout( function(){
					newClip.start();
				}, 33 );
			}// passData()
			
			
			swfLoader.detectLastFrame = function( newClip, nextEvent )
			{
				newClip.detectLastFrame = {
					parent:newClip,
					nextEvent:nextEvent,
					swfData:thisCommand_obj.data,
					loop:function( thisObj )		// repeatedly check for last frame
					{
						if(	thisObj.parent._currentframe == thisObj.parent._totalframes
						||	thisObj.parent._currentframe == undefined){
							ROOT.swfLoader.remove( thisObj.swfData );
							// stop checking for last frame
							clearInterval( thisObj.intervalId );
							// restore root
							_global.ROOT = swfLoader.root;
							// start next event
							var sameLevel = (swfLoader.levelId == ROOT.game_mc.uid);
							if(sameLevel)
								thisObj.nextEvent();
						}// if:  last frame
					},// loop()
					intervalId:null,
					start:function(){		// begin loop
						if(this.intervalId!=null)
							clearInterval( this.intervalId );
						this.intervalId = setInterval( this.loop, 34, this );
					}// start()
				}// detectLastFrame obj
				newClip.detectLastFrame.start();		// start checking for the last frame
			}// detectLastFrame()
			
			
			
			if(externalFile)
			{// external file is being loaded
				swfLoader.onLoadInit = function( newClip )
				{
					swfLoader.passData( newClip, this.commandData );
					if(swfLoader.waitForEnd)
						swfLoader.detectLastFrame( newClip, this.nextEvent );
					delete swfLoader;
				}// file loaded()
				swfLoader.onLoadError = function( newClip ){
					this.unloadClip( newClip );		// remove empty movieClip
					newClip.removeMovieClip();		// make sure it's gone
					delete swfLoader;
				}// error()
				swfLoader.loadClip( linkage, target[newName] );
			}// external file is being loaded
			else
			{// internal file is being loaded
				swfLoader.passData( target[newName], swfLoader.commandData );
				if(swfLoader.waitForEnd)
					swfLoader.detectLastFrame( target[newName], thisCommand_obj.nextEvent );
				delete swfLoader;
			}// internal file is being loaded
			
			
			if(thisCommand_obj.data.waitForEnd == false)
				thisCommand_obj.nextEvent();
		}// run()
	}// if:  linkage specified
	else
	{// if:  no linkage given
		command_obj.run = function( thisCommand_obj, preserveSwfloader )
		{
			// remove the target swf's command from storage
			if(!preserveSwfloader)
				ROOT.swfLoader.remove( thisCommand_obj.data );
			if(TRACE_SCRIPT)
				trace("removeSwf: "+thisCommand_obj.data.linkage+"  named: "+thisCommand_obj.data.name);
			// if "auto" command has just started, wait a bit before potentially removing this sprite  (via flags)	(this prevents crashing the game)
			var autoDelay = 1;
			var endTime = getTimer();
			var elapsedTime = endTime - startTime;
			if(TRACE_SCRIPT)
				trace("\t elapsedTime: "+elapsedTime);
			if(isNaN(elapsedTime)  ||  elapsedTime>autoDelay)
			{// if:  time has passed since "auto" script started		(prevent game crash)
				// figure out the target container
				var defaultContainer = "OVERLAY";
				target_str = nestedEval(thisCommand_obj.data.target, "RAM", "_this");
				var startAt = target_str.indexOf(".");
				if(startAt==-1)
				{// if:  path has NO objects
					var container = defaultContainer;
					var containerIsGlobal = false;
					for(var nam in _global){
						if(nam == target_str){
							containerIsGlobal = true;
							break;		// stop searching
						}// if:  Path is a global object
					}// for:  each global object
					var theRest = target_str;
					var target = (containerIsGlobal) ? eval(theRest) : eval(container+"."+theRest);
					if(target_str=="this")
						var target = _this;
				}// if:  path has NO objects
				else
				{// if:  path has objects
					var containerName = target_str.substr(0, startAt);
					var container = nestedEval(containerName, "RAM", "_this");
					var theRest = target_str.substr( startAt+1 );
					var target = eval(container+"."+theRest);
				}// if:  path has objects
				var targetName = nestedEval(thisCommand_obj.data.name, "RAM", "_this");
				
				
				// if it's a sprite, remove it from update list  (so variables don't restore it)
				if(target == SPRITES  &&  target[targetName].remove){
					target[targetName].remove();
				}else{
					// remove the specified movieClip		(WARNING:  onUnload() might get called more than once!!! )
//					target[targetName].unload();
//					target[targetName].onUnload();
					callUnload( target[targetName] );
					target[targetName].removeMovieClip();
					//target[targetName]._name = null;
				}
				// continue the script
				thisCommand_obj.nextEvent();
			}// if:  time has passed since "auto" script started		(prevent game crash)
			else
			{// if:  NO time has passed since the "auto" script began
				if(TRACE_SCRIPT)
					trace("\t too early, wait for 1 millisecond");
				setTimeout( thisCommand_obj.run, autoDelay, thisCommand_obj );
			}// if:  NO time has passed since the "auto" script began
		}// run()

	}// if:  no linkage given
}// define_swf()